Attribute VB_Name = "modProfiles"
Option Explicit

Public SelectedTab As Integer

Public Property Get SelectedBot() As Integer
    SelectedBot = TabToBotIndex(SelectedTab)
End Property

Public Sub LoadProfile(ByVal strProfile As String)
    On Error GoTo hErr
    Static FirstLoad As Boolean
    
    Dim n As Integer
    For n = 0 To frmBot.Bot.UBound
        If (frmBot.Bot(n).Profile = strProfile) Then
            MsgBox "Profile " & """" & strProfile & """" & " is already loaded!", vbExclamation
            Exit Sub
        End If
    Next n

    Dim F As String, intBot As Integer, r As Integer
    F = AppData & "Profiles\" & strProfile & ".ini"
    intBot = -1
    For r = 0 To frmBot.Bot.UBound
        If (Not frmBot.Bot(r).IsLoaded) Then intBot = r: Exit For
    Next r
    If (intBot = -1) Then
        Load frmBot.Bot(frmBot.Bot.UBound + 1)
        intBot = frmBot.Bot.UBound
        Load frmBot.rtbChat(intBot)
        Load frmBot.rtbWhsp(intBot)
        Load frmBot.lvUsers(intBot)
        frmBot.rtbChat(intBot).Visible = True
        frmBot.rtbWhsp(intBot).Visible = True
        frmBot.lvUsers(intBot).Visible = True
    End If
    
    If Not frmBot.mnuWarCraftIcons.Checked Then
        Set frmBot.lvUsers(intBot).SmallIcons = frmBot.imlClassic
    Else
        Set frmBot.lvUsers(intBot).SmallIcons = frmBot.imlWarCraft
    End If
    
    frmBot.rtbChat(intBot).text = vbNullString
    frmBot.lvUsers(intBot).ListItems.Clear
    frmBot.Bot(intBot).BotIndex = intBot
    LoadProfileValues F, frmBot.Bot(intBot)
    frmBot.Bot(intBot).IsLoaded = True
    frmBot.Bot(intBot).Profile = strProfile
    frmBot.Bot(intBot).DbFile = AppData & "Profiles\" & strProfile & ".db"
    frmBot.Bot(intBot).ReloadDatabase
    frmBot.tbsProfile.Tabs.Add(, , strProfile, 1).Tag = intBot
    If SelectedTab = 0 Then ViewProfile frmBot.tbsProfile.Tabs.Count
    'If Not FirstLoad Then frmBot.mnuCheckVersion_Click: FirstLoad = True
    frmBot.Form_Resize
    Exit Sub
hErr:
    Close #1
    ErrorHandler "Profiles", "LoadProfile"
End Sub

Public Sub LoadProfileValues(F As String, b As BNCS)
    On Error GoTo hErr
    b.Config.Idle = (UCase$(ReadIni(F, "Idle", "Idle")) = "Y")
    b.Config.IdleTime = Val(ReadIni(F, "Idle", "Time"))
    b.Config.IdleMessage = ReadIni(F, "Idle", "Message")
    b.Config.Greet = (UCase$(ReadIni(F, "Greeting", "Greeting")) = "Y")
    b.Config.GreetMessage = ReadIni(F, "Greeting", "Message")
    b.Config.Farewell = (UCase$(ReadIni(F, "Farewell", "Farewell")) = "Y")
    b.Config.FarewellMessage = ReadIni(F, "Farewell", "Message")
    b.Config.BnlsServer = ReadIni(F, "BNLS", "Server")
    b.Config.Cdkey = ReadIni(F, "Main", "Cdkey")
    b.Config.Realm = LCase$(RealmToStr(Val(ReadIni(F, "Main", "Realm"))))
    b.Config.CdkeyEx = ReadIni(F, "Main", "CdkeyEx")
    b.Config.Channel = ReadIni(F, "Main", "Channel")
    b.Config.JoinChannel = (UCase$(ReadIni(F, "Main", "Join") = "Y"))
    b.Config.Password = ReadIni(F, "Main", "Password")
    b.Config.Trigger = ReadIni(F, "Main", "Trigger")
    b.Config.NewPassword = ReadIni(F, "Main", "NewPassword")
    b.Config.Email = ReadIni(F, "Register", "Email")
    b.Config.NewEmail = ReadIni(F, "Register", "NewEmail")
    b.Config.ProductID = ReadIni(F, "Main", "ProductID")
    b.Config.Verbyte = CByte(Val("&H0" & ReadIni(F, "Main", "Verbyte")))
    b.Config.Proxy.Proxy = ReadIni(F, "Proxy", "Proxy")
    b.Config.Proxy.Port = Val(ReadIni(F, "Proxy", "Port"))
    b.Config.Proxy.Ident = ReadIni(F, "Proxy", "Ident")
    b.Config.Proxy.Socks = IIf(Val(ReadIni(F, "Proxy", "SocksVer")) = 4, SocksVer.Socks4, SocksVer.Socks5)
    b.Config.Proxy.UseProxy = (UCase$(ReadIni(F, "Proxy", "UseProxy") = "Y"))
    b.Config.Server = ReadIni(F, "Main", "Server")
    b.Config.UseBNLS = (UCase$(ReadIni(F, "BNLS", "UseBNLS") = "Y"))
    b.Config.Username = ReadIni(F, "Main", "Username")
    If LenB(b.Config.Trigger) = 0 Then b.Config.Trigger = "."
    Select Case Val(ReadIni(F, "Register", "Mode"))
    Case 0, 1, 2, 3
        b.Config.Register = Val(ReadIni(F, "Register", "Mode"))
    Case Else
        b.Config.Register = Disabled
    End Select
    Exit Sub
hErr:
    Close #1
    ErrorHandler "Profiles", "LoadProfileValues"
End Sub

Public Sub ViewProfile(ByVal intTab As Integer)
    On Error GoTo hErr
    Dim intBot As Integer
    intBot = TabToBotIndex(intTab)
    If (intBot <> -1) Then
        SelectedTab = intTab
        frmBot.Bot(intBot).IsActive = False
        frmBot.rtbChat(intBot).ZOrder vbBringToFront
        frmBot.rtbWhsp(intBot).ZOrder vbBringToFront
        frmBot.lvUsers(intBot).ZOrder vbBringToFront
        If frmBot.Bot(intBot).IsWarCraft And frmBot.Bot(intBot).IsOnline Then
            frmBot.mnuInClan.Visible = (frmBot.Bot(intBot).Self.Clanned)
            frmBot.mnuClan.Visible = Not frmBot.mnuInClan.Visible
        Else
            frmBot.mnuInClan.Visible = False
            frmBot.mnuClan.Visible = False
        End If
        frmBot.mnuCharacterList.Visible = frmBot.Bot(intBot).IsDiablo
        frmBot.mnuConnect.Caption = IIf(frmBot.Bot(intBot).IsConnected, "Reconnect", "Connect")
    Else
        If (frmBot.tbsProfile.Tabs.Count > 0) Then ViewProfile 1
    End If
    If frmBot.Bot(intBot).IsOnline Then
        frmBot.lblChannel.Caption = "#" & frmBot.Bot(intBot).Self.Channel & " (" & frmBot.lvUsers(intBot).ListItems.Count & ")"
    Else
        frmBot.lblChannel.Caption = "-- Offline --"
    End If
    RefreshChannel
    frmBot.tmrView_Timer
    frmBot.Form_Resize
    Exit Sub
hErr:
    Close #1
    ErrorHandler "Profiles", "ViewProfile"
End Sub

Public Sub UnloadProfile(ByVal intTab As Integer)
    On Error GoTo hErr
    Dim intBot As Integer
    intBot = TabToBotIndex(intTab)
    If (intBot > -1) Then
        frmBot.Bot(intBot).Disconnect
        frmBot.Bot(intBot).Profile = vbNullString
        frmBot.Bot(intBot).IsLoaded = False
        Set frmBot.Bot(intBot).Self = New clsSelf
        Set frmBot.Bot(intBot).Config = New clsConfig
    End If
    If TabWithinBounds(intTab) Then
        frmBot.tbsProfile.Tabs.Remove intTab
        If (frmBot.tbsProfile.Tabs.Count > 0) Then ViewProfile 1
    Else
        MsgBox "Cannot unload profile, tab index is out of bounds!", vbExclamation
    End If
    Exit Sub
hErr:
    Close #1
    ErrorHandler "Profiles", "UnloadProfile"
End Sub

Public Function BotToTabIndex(intBot As Integer) As Integer
    On Error GoTo hErr
    If frmBot.tbsProfile.Tabs.Count > 0 Then
        Dim I As Integer
        For I = 1 To frmBot.tbsProfile.Tabs.Count
            If (Val(frmBot.tbsProfile.Tabs(I).Tag) = intBot) Then
                BotToTabIndex = I
                Exit Function
            End If
        Next I
    End If
hErr:
    BotToTabIndex = -1
End Function

Public Function TabToBotIndex(intTab As Integer) As Integer
    If TabWithinBounds(intTab) Then
        TabToBotIndex = Val(frmBot.tbsProfile.Tabs(intTab).Tag)
    Else
        TabToBotIndex = -1
    End If
End Function

Public Function TabWithinBounds(intTab As Integer) As Boolean
    TabWithinBounds = (intTab <= frmBot.tbsProfile.Tabs.Count And intTab > 0)
End Function
